<?php

namespace App\Http\Resources\Web;

use Illuminate\Http\Resources\Json\JsonResource;

class TherapistCommunitysResource extends JsonResource
{
    public static $wrap = null;
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $therapist_community_settings = $this->relationLoaded('therapist_community_settings') ? $this->whenLoaded('therapist_community_settings') : null;
        $therapist_community_categories = $this->relationLoaded('therapist_community_categories') ? $this->whenLoaded('therapist_community_categories') : null;
        $languages = $this->relationLoaded('languages') ? $this->whenLoaded('languages') : null;
        $tags = $this->relationLoaded('tags') ? $this->whenLoaded('tags') : null;
        $therapist_community_therapists = $this->relationLoaded('therapist_community_therapists') ? $this->whenLoaded('therapist_community_therapists') : null;
        $therapist_community_certifications = $this->relationLoaded('therapist_community_certifications') ? $this->whenLoaded('therapist_community_certifications') : null;
        $therapist_community_broadcasts = $this->relationLoaded('therapist_community_broadcasts') ? $this->whenLoaded('therapist_community_broadcasts') : null;
        $therapist_community_podcasts = $this->relationLoaded('therapist_community_podcasts') ? $this->whenLoaded('therapist_community_podcasts') : null;
        $therapist_community_services = $this->relationLoaded('therapist_community_services') ? $this->whenLoaded('therapist_community_services') : null;
        $therapist_community_events = $this->relationLoaded('therapist_community_events') ? $this->whenLoaded('therapist_community_events') : null;
        $appointment_schedules = $this->relationLoaded('appointment_schedules') ? $this->whenLoaded('appointment_schedules') : null;
        $therapist_community_posts = $this->relationLoaded('therapist_community_posts') ? $this->whenLoaded('therapist_community_posts') : null;
        $therapist_community_archives = $this->relationLoaded('therapist_community_archives') ? $this->whenLoaded('therapist_community_archives') : null;
        $therapist_community_reviews = $this->relationLoaded('therapist_community_reviews') ? $this->whenLoaded('therapist_community_reviews') : null;
        $pricing_plan = $this->relationLoaded('pricing_plan') ? $this->whenLoaded('pricing_plan') : null;
        $country = $this->relationLoaded('country') ? $this->whenLoaded('country') : null;
        $state = $this->relationLoaded('state') ? $this->whenLoaded('state') : null;
        $city = $this->relationLoaded('city') ? $this->whenLoaded('city') : null;
        $appointments = $this->relationLoaded('appointments') ? $this->whenLoaded('appointments'):null;
        if ($therapist_community_reviews) {
            $rating = $therapist_community_reviews->avg('rating');
            if (!$rating) {
                $rating = 0;
            } else {
                $rating = round($rating, 2);
            }
        } else {
            $rating = 0;
        }
        return [
            "id" => $this->id,
            "user_id" => $this->user_id,
            "country_id" => $this->country_id,
            "country_name" => $country ? $country->name : "",
            "state_id" => $this->state_id,
            "state_name" => $state ? $state->name : "",
            "city_id" => $this->city_id,
            "city_name" => $city ? $city->name : "",
            "distance" => $this->distance,

            "name" => $this->name,
            "first_name" => $this->first_name,
            "last_name" => $this->last_name,
            "therapist_community_name" => $this->therapist_community_name,
            "therapist_community_website" => $this->therapist_community_website,
            "description" => $this->description,
            "description_translations" =>  $this->getTranslations('description'),
            "address_line_1" => $this->address_line_1,
            "address_line_2" => $this->address_line_2,
            "longitude" => $this->longitude,
            "latitude" => $this->latitude,
            "user_name" => $this->user_name,
            "zip_code" => $this->zip_code,
            "is_approved" => $this->is_approved,
            "approved_at" => $this->approved_at,
            "is_active" => $this->is_active,
            "is_featured" => $this->is_featured,

            'prefix' => $this->prefix,
            'suffix' => $this->suffix,
            'home_phone' => $this->home_phone,
            'cell_phone' => $this->cell_phone,
            'job_title' => $this->job_title,
            'company' => $this->company,
            'website' => $this->website,
            'email' => $this->email,

            'billing_address_line_1' => $this->billing_address_line_1,
            'billing_address_line_2' => $this->billing_address_line_2,
            'billing_country_id' => $this->billing_country_id,
            'billing_state_id' => $this->billing_state_id,
            'billing_city_id' => $this->billing_city_id,
            'billing_zip_code' => $this->billing_zip_code,

            'shipping_address_line_1' => $this->shipping_address_line_1,
            'shipping_address_line_2' => $this->shipping_address_line_2,
            'shipping_country_id' => $this->shipping_country_id,
            'shipping_state_id' => $this->shipping_state_id,
            'shipping_city_id' => $this->shipping_city_id,
            'shipping_zip_code' => $this->shipping_zip_code,

            'work_address_line_1' => $this->work_address_line_1,
            'work_address_line_2' => $this->work_address_line_2,
            'work_country_id' => $this->work_country_id,
            'work_state_id' => $this->work_state_id,
            'work_city_id' => $this->work_city_id,
            'work_zip_code' => $this->work_zip_code,


            "icon" => $this->icon,
            "image" => $this->image,
            "cover_image" => $this->cover_image,
            "rating" => $rating,
            "booked_appointments" => count($appointments),
            "pricing_plan_name" => $pricing_plan->name ?? "",
            "therapist_community_modules" => $pricing_plan ? $pricing_plan->therapist_community_modules()->pluck('pricing_plan_modules.module_code')->toArray() : [],
            "therapist_community_settings" => $therapist_community_settings ? TherapistCommunitySettingsResource::collection($this->whenLoaded('therapist_community_settings', function () {
                return $this->therapist_community_settings;
            }))->pluck('value', 'name')->toArray() : [],
            "therapist_community_category_ids" => $therapist_community_categories ? TherapistCommunityCategoriesResource::collection($this->whenLoaded('therapist_community_categories', function () {
                return $this->therapist_community_categories;
            }))->pluck('id')->toArray() : [],
            "therapist_community_categories" => $therapist_community_categories ? TherapistCommunityCategoriesResource::collection($therapist_community_categories) : [],
            "language_ids" => $languages ? AllLanguagesResource::collection($this->whenLoaded('languages', function () {
                return $this->languages;
            }))->pluck('id')->toArray() : [],
            "languages" => $languages ? AllLanguagesResource::collection($languages) : [],
            "tag_ids" => $tags ? TagsResource::collection($this->whenLoaded('tags', function () {
                return $this->tags;
            }))->pluck('id')->toArray() : [],
            "tags" => $tags ? TagsResource::collection($tags) : [],
            "therapist_community_therapists" => $therapist_community_therapists ? TherapistsResource::collection($therapist_community_therapists) : [],
            "therapist_community_broadcasts" => $therapist_community_broadcasts ? BroadcastsResource::collection($therapist_community_broadcasts) : [],
            "therapist_community_podcasts" => $therapist_community_podcasts ? BroadcastsResource::collection($therapist_community_podcasts) : [],
            "therapist_community_services" => $therapist_community_services ? ServicesResource::collection($therapist_community_services) : [],
            "therapist_community_events" => $therapist_community_events ? EventsResource::collection($therapist_community_events) : [],
            "therapist_community_posts" => $therapist_community_posts ? PostsResource::collection($therapist_community_posts) : [],
            "therapist_community_archives" => $therapist_community_archives ? PostsResource::collection($therapist_community_archives) : [],
            "therapist_community_reviews" => $therapist_community_reviews ? TherapistCommunityReviewsResource::collection($therapist_community_reviews) : [],
            "therapist_community_certifications" => $therapist_community_certifications ? CertificationsResource::collection($therapist_community_certifications) : [],
            "appointment_types" => $appointment_schedules ? AppointmentSchedulesResource::collection($appointment_schedules)->keyBy('appointment_type.type') : [],
            "created_at" => $this->created_at,
            "updated_at" => $this->updated_at,
        ];
    }
}
